#!/usr/bin/python
# coding: iso-8859-15

global logging
import logging
import logging.handlers

global string
import string

## @cond NO_DOC
class hsl20_4_logging_syslog:

    ## Konstruktor
    ## TODO In Interface bernehmen
    def __init__(self, framework, name, param):
        self.__name = name
        self.__logger = logging.getLogger(name)
        self.__logger.setLevel(logging.DEBUG)
        if not self.__checkHandler(logging.handlers.SysLogHandler):
            syslog = logging.handlers.SysLogHandler(param)
            syslog.setFormatter(logging.Formatter("%(asctime)s|%(name)s|%(levelname)s|%(message)s"))
            self.__logger.addHandler(syslog)

        hsl20_4.Framework._get_global_debug_section()._internal_register(self.__on_debug)

    def __on_debug(self):
        result = {}
        result[self.__name+".logging.type"] = "SYSLOG"
        return (result,None)

    def __checkHandler(self, handlerClass):
        if self.__logger!=None:
            for hdlr in self.__logger.handlers:
                if isinstance(hdlr, handlerClass):
                    return True
        return False

    def set_level(self, level):
        self.__logger.setLevel(level)

    def info(self, msg):
        self.__logger.info(msg)

    def error(self, msg):
        self.__logger.error(msg)

    def debug(self, msg):
        self.__logger.debug(msg)

    def warning(self, msg):
        self.__logger.warning(msg)

    def critical(self, msg):
        self.__logger.critical(msg)

    def exception(self, comment):
        self.__logger.exception(comment)
## @endcond
